!Object constantsFor: 'Geos Libraries'!

geosLIB37 'SYSTEM\math'! !

!Object constantsFor: 'Geos vardata'!

tempFloatCtrlUserDefineActive 27648!
!

!Object constantsFor: 'Geos messages'!

requestMoniker 27648!
optionStyleChange 27649!
optionBooleanChange 27650!
selected 27651!
userDefInvoke 27652!
updateUserDefSamples 27653!
userDefOk 27654!
delete 27655!
apply 27656!
numDecimals 27657!
decimalOffset 27658!
userDefCancel 27659!
!

!Geos class methodsFor: 'library calls'!

FloatInit: stackSize with: stackType
	"void pascal FloatInit(word stackSize, FloatStackType stackType) in math.h"
	^GEOS call: stackSize with: stackType with: #[37 0 123 1 1 0]!

FloatExit
	"void pascal FloatExit(void) in math.h"
	^GEOS call: #[37 0 124 0]!

FloatComp
	"word pascal FloatComp(void) in math.h"
	^GEOS call: #[37 0 112 1]!

FloatCompAndDrop
	"word pascal FloatCompAndDrop(void) in math.h"
	^GEOS call: #[37 0 113 1]!

FloatCompESDI: ptrFloatNum
	"word pascal FloatCompESDI(FloatNum *) in math.h"
	^GEOS call: ptrFloatNum with: #[37 0 114 3 1]!

FloatEq0
	"word pascal FloatEq0(void) in math.h"
	^GEOS call: #[37 0 115 1]!

FloatLt0
	"word pascal FloatLt0(void) in math.h"
	^GEOS call: #[37 0 116 1]!

FloatGt0
	"word pascal FloatGt0(void) in math.h"
	^GEOS call: #[37 0 117 1]!

FloatPushNumber: number
	"word pascal FloatPushNumber(FloatNum *number) in math.h"
	^GEOS call: number with: #[37 0 118 3 1]!

FloatPopNumber: number
	"word pascal FloatPopNumber(FloatNum *number) in math.h"
	^GEOS call: number with: #[37 0 119 3 1]!

FloatRoll: num
	"void pascal FloatRoll(word num) in math.h"
	^GEOS call: num with: #[37 0 137 1 0]!

FloatRollDown: num
	"void pascal FloatRollDown(word num) in math.h"
	^GEOS call: num with: #[37 0 138 1 0]!

FloatPick: num
	"void pascal FloatPick(word num) in math.h"
	^GEOS call: num with: #[37 0 139 1 0]!

FloatSwap
	"void pascal FloatSwap(void) in math.h"
	^GEOS call: #[37 0 84 0]!

FloatOver
	"void pascal FloatOver(void) in math.h"
	^GEOS call: #[37 0 64 0]!

FloatSetStackPointer: newValue
	"void pascal FloatSetStackPointer(word newValue) in math.h"
	^GEOS call: newValue with: #[37 0 136 1 0]!

FloatGetStackPointer
	"int pascal FloatGetStackPointer(void) in math.h"
	^GEOS call: #[37 0 91 4]!

FloatGeos80ToIEEE64: num
	"void pascal FloatGeos80ToIEEE64(double *num) in math.h"
	^GEOS call: num with: #[37 0 126 3 0]!

FloatGeos80ToIEEE32: num
	"void pascal FloatGeos80ToIEEE32(float *num) in math.h"
	^GEOS call: num with: #[37 0 127 3 0]!

FloatIEEE64ToGeos80: num
	"void pascal FloatIEEE64ToGeos80(double *num) in math.h"
	^GEOS call: num with: #[37 0 128 3 0]!

FloatIEEE32ToGeos80: num
	"void pascal FloatIEEE32ToGeos80(float *num) in math.h"
	^GEOS call: num with: #[37 0 129 3 0]!

FloatDwordToFloat: num
	"void pascal FloatDwordToFloat(long num) in math.h"
	^GEOS call: num with: #[37 0 131 2 0]!

FloatWordToFloat: num
	"void pascal FloatWordToFloat(word num) in math.h"
	^GEOS call: num with: #[37 0 130 1 0]!

FloatFloatToDword
	"long pascal FloatFloatToDword(void) in math.h"
	^GEOS call: #[37 0 89 2]!

Float0
	"void pascal Float0(void) in math.h"
	^GEOS call: #[37 0 5 0]!

Float1
	"void pascal Float1(void) in math.h"
	^GEOS call: #[37 0 7 0]!

FloatMinus1
	"void pascal FloatMinus1(void) in math.h"
	^GEOS call: #[37 0 3 0]!

FloatMinusPoint5
	"void pascal FloatMinusPoint5(void) in math.h"
	^GEOS call: #[37 0 4 0]!

FloatPoint5
	"void pascal FloatPoint5(void) in math.h"
	^GEOS call: #[37 0 6 0]!

Float2
	"void pascal Float2(void) in math.h"
	^GEOS call: #[37 0 8 0]!

Float5
	"void pascal Float5(void) in math.h"
	^GEOS call: #[37 0 9 0]!

Float10
	"void pascal Float10(void) in math.h"
	^GEOS call: #[37 0 10 0]!

Float3600
	"void pascal Float3600(void) in math.h"
	^GEOS call: #[37 0 11 0]!

Float16384
	"void pascal Float16384(void) in math.h"
	^GEOS call: #[37 0 12 0]!

Float86400
	"void pascal Float86400(void) in math.h"
	^GEOS call: #[37 0 13 0]!

FloatPi
	"void pascal FloatPi(void) in math.h"
	^GEOS call: #[37 0 65 0]!

FloatPiDiv2
	"void pascal FloatPiDiv2(void) in math.h"
	^GEOS call: #[37 0 66 0]!

FloatAbs
	"void pascal FloatAbs(void) in math.h"
	^GEOS call: #[37 0 14 0]!

FloatAdd
	"void pascal FloatAdd(void) in math.h"
	^GEOS call: #[37 0 15 0]!

FloatArcCos
	"void pascal FloatArcCos(void) in math.h"
	^GEOS call: #[37 0 16 0]!

FloatArcCosh
	"void pascal FloatArcCosh(void) in math.h"
	^GEOS call: #[37 0 17 0]!

FloatArcSin
	"void pascal FloatArcSin(void) in math.h"
	^GEOS call: #[37 0 18 0]!

FloatArcSinh
	"void pascal FloatArcSinh(void) in math.h"
	^GEOS call: #[37 0 19 0]!

FloatArcTan
	"void pascal FloatArcTan(void) in math.h"
	^GEOS call: #[37 0 20 0]!

FloatArcTan2
	"void pascal FloatArcTan2(void) in math.h"
	^GEOS call: #[37 0 21 0]!

FloatArcTanh
	"void pascal FloatArcTanh(void) in math.h"
	^GEOS call: #[37 0 22 0]!

FloatCos
	"void pascal FloatCos(void) in math.h"
	^GEOS call: #[37 0 26 0]!

FloatCosh
	"void pascal FloatCosh(void) in math.h"
	^GEOS call: #[37 0 27 0]!

FloatDepth
	"word pascal FloatDepth(void) in math.h"
	^GEOS call: #[37 0 28 1]!

FloatDIV
	"void pascal FloatDIV(void) in math.h"
	^GEOS call: #[37 0 29 0]!

FloatDivide
	"void pascal FloatDivide(void) in math.h"
	^GEOS call: #[37 0 30 0]!

FloatDivide2
	"void pascal FloatDivide2(void) in math.h"
	^GEOS call: #[37 0 31 0]!

FloatDivide10
	"void pascal FloatDivide10(void) in math.h"
	^GEOS call: #[37 0 32 0]!

FloatDrop
	"void pascal FloatDrop(void) in math.h"
	^GEOS call: #[37 0 33 0]!

FloatDup
	"void pascal FloatDup(void) in math.h"
	^GEOS call: #[37 0 34 0]!

FloatExp
	"void pascal FloatExp(void) in math.h"
	^GEOS call: #[37 0 38 0]!

FloatExponential
	"void pascal FloatExponential(void) in math.h"
	^GEOS call: #[37 0 39 0]!

FloatFactorial
	"void pascal FloatFactorial(void) in math.h"
	^GEOS call: #[37 0 42 0]!

FloatFrac
	"void pascal FloatFrac(void) in math.h"
	^GEOS call: #[37 0 43 0]!

FloatInt
	"void pascal FloatInt(void) in math.h"
	^GEOS call: #[37 0 46 0]!

FloatIntFrac
	"void pascal FloatIntFrac(void) in math.h"
	^GEOS call: #[37 0 47 0]!

FloatInverse
	"void pascal FloatInverse(void) in math.h"
	^GEOS call: #[37 0 48 0]!

FloatLg
	"void pascal FloatLg(void) in math.h"
	^GEOS call: #[37 0 49 0]!

FloatLg10
	"void pascal FloatLg10(void) in math.h"
	^GEOS call: #[37 0 50 0]!

FloatLn
	"void pascal FloatLn(void) in math.h"
	^GEOS call: #[37 0 51 0]!

FloatLn1plusX
	"void pascal FloatLn1plusX(void) in math.h"
	^GEOS call: #[37 0 52 0]!

FloatLn2
	"void pascal FloatLn2(void) in math.h"
	^GEOS call: #[37 0 53 0]!

FloatLn10
	"void pascal FloatLn10(void) in math.h"
	^GEOS call: #[37 0 54 0]!

FloatLog
	"void pascal FloatLog(void) in math.h"
	^GEOS call: #[37 0 55 0]!

FloatMax
	"void pascal FloatMax(void) in math.h"
	^GEOS call: #[37 0 57 0]!

FloatMin
	"void pascal FloatMin(void) in math.h"
	^GEOS call: #[37 0 58 0]!

FloatMod
	"void pascal FloatMod(void) in math.h"
	^GEOS call: #[37 0 59 0]!

FloatMultiply
	"void pascal FloatMultiply(void) in math.h"
	^GEOS call: #[37 0 60 0]!

FloatMultiply2
	"void pascal FloatMultiply2(void) in math.h"
	^GEOS call: #[37 0 61 0]!

FloatMultiply10
	"void pascal FloatMultiply10(void) in math.h"
	^GEOS call: #[37 0 62 0]!

FloatNegate
	"void pascal FloatNegate(void) in math.h"
	^GEOS call: #[37 0 63 0]!

FloatRandom
	"void pascal FloatRandom(void) in math.h"
	^GEOS call: #[37 0 70 0]!

FloatRandomize: rgiflag with: seed
	"void pascal FloatRandomize(RandomGenInitFlags rgiflag, dword seed) in math.h"
	^GEOS call: rgiflag with: seed with: #[37 0 141 1 2 0]!

FloatRandomN
	"void pascal FloatRandomN(void) in math.h"
	^GEOS call: #[37 0 72 0]!

FloatRot
	"void pascal FloatRot(void) in math.h"
	^GEOS call: #[37 0 75 0]!

FloatRound: numDecimalPlaces
	"void pascal FloatRound(byte numDecimalPlaces) in math.h"
	^GEOS call: numDecimalPlaces with: #[37 0 120 1 0]!

FloatSin
	"void pascal FloatSin(void) in math.h"
	^GEOS call: #[37 0 77 0]!

FloatSinh
	"void pascal FloatSinh(void) in math.h"
	^GEOS call: #[37 0 78 0]!

FloatSqr
	"void pascal FloatSqr(void) in math.h"
	^GEOS call: #[37 0 79 0]!

FloatSqrt
	"void pascal FloatSqrt(void) in math.h"
	^GEOS call: #[37 0 80 0]!

FloatSqrt2
	"void pascal FloatSqrt2(void) in math.h"
	^GEOS call: #[37 0 81 0]!

FloatSub
	"void pascal FloatSub(void) in math.h"
	^GEOS call: #[37 0 83 0]!

FloatTan
	"void pascal FloatTan(void) in math.h"
	^GEOS call: #[37 0 85 0]!

FloatTanh
	"void pascal FloatTanh(void) in math.h"
	^GEOS call: #[37 0 86 0]!

Float10ToTheX
	"void pascal Float10ToTheX(void) in math.h"
	^GEOS call: #[37 0 87 0]!

FloatTrunc
	"void pascal FloatTrunc(void) in math.h"
	^GEOS call: #[37 0 88 0]!

FloatEpsilon
	"void pascal FloatEpsilon (void) in math.h"
	^GEOS call: #[37 0 36 0]!

FloatAsciiToFloat: floatAtoFflags with: stringLength with: string with: resultLocation
	"Boolean pascal FloatAsciiToFloat(word floatAtoFflags, word stringLength, void *string, void *resultLocation) in math.h"
	^GEOS call: floatAtoFflags with: stringLength with: string with: resultLocation with: #[37 0 108 1 1 3 3 4]!

FloatFloatToAscii_StdFormat: string with: number with: format with: numDigits with: numFractionalDigits
	"word pascal FloatFloatToAscii_StdFormat(char *string, FloatNum *number, FloatFloatToAsciiFormatFlags format, word numDigits, word numFractionalDigits) in math.h"
	^GEOS call: string with: number with: format with: numDigits with: numFractionalDigits with: #[37 0 110 3 3 1 1 1 1]!

FloatFloatToAscii: stackFrame with: resultString with: number
	"word pascal FloatFloatToAscii(FFA_stackFrame *stackFrame, char *resultString, FloatNum *number) in math.h"
	^GEOS call: stackFrame with: resultString with: number with: #[37 0 201 3 3 3 1]!

FloatFloatIEEE64ToAscii_StdFormat: string with: number with: format with: numDigits with: numFractionalDigits
	"word pascal FloatFloatIEEE64ToAscii_StdFormat(char *string, IEEE64FloatNum number, FloatFloatToAsciiFormatFlags format, word numDigits, word numFractionalDigits) in math.h"
	^GEOS call: string with: number with: format with: numDigits with: numFractionalDigits with: #[37 0 111 3 64 8 1 1 1 1]!

FloatTimeNumberGetSeconds
	"void pascal FloatTimeNumberGetSeconds(void) in math.h"
	^GEOS call: #[37 0 102 0]!

FloatStringGetDateNumber: dateString
	"word pascal FloatStringGetDateNumber(char *dateString) in math.h"
	^GEOS call: dateString with: #[37 0 121 3 1]!

FloatStringGetTimeNumber: timeString
	"word pascal FloatStringGetTimeNumber(char *timeString) in math.h"
	^GEOS call: timeString with: #[37 0 122 3 1]!

FloatGetDaysInMonth: year with: month
	"byte pascal FloatGetDaysInMonth(word year, byte month) in math.h"
	^GEOS call: year with: month with: #[37 0 132 1 1 1]!

FloatTimeNumberGetMinutes
	"void pascal FloatTimeNumberGetMinutes(void) in math.h"
	^GEOS call: #[37 0 101 0]!

FloatTimeNumberGetHour
	"void pascal FloatTimeNumberGetHour(void) in math.h"
	^GEOS call: #[37 0 100 0]!

FloatGetDateNumber: year with: month with: day
	"FloatErrorType pascal FloatGetDateNumber(word year, byte month, byte day) in math.h"
	^GEOS call: year with: month with: day with: #[37 0 133 1 1 1 1]!

FloatGetTimeNumber: hours with: minutes with: seconds
	"FloatErrorType pascal FloatGetTimeNumber(byte hours, byte minutes, byte seconds) in math.h"
	^GEOS call: hours with: minutes with: seconds with: #[37 0 134 1 1 1 1]!

FloatDateNumberGetWeekday
	"void pascal FloatDateNumberGetWeekday(void) in math.h"
	^GEOS call: #[37 0 96 0]!

FloatDateNumberGetYear
	"word pascal FloatDateNumberGetYear(void) in math.h"
	^GEOS call: #[37 0 94 1]!

FloatDateNumberGetMonthAndDay: month with: day
	"void pascal FloatDateNumberGetMonthAndDay(byte *month, byte *day) in math.h"
	^GEOS call: month with: day with: #[37 0 135 3 3 0]!

FloatGetNumDigitsInIntegerPart
	"word pascal FloatGetNumDigitsInIntegerPart(void) in math.h"
	^GEOS call: #[37 0 44 1]!

FloatFormatNumber: formatToken with: userDefBlkHan with: userDefFileHan with: floatNum with: resultLocation
	"void pascal FloatFormatNumber(FormatIdType formatToken, word userDefBlkHan, word userDefFileHan, FloatNum *floatNum, char *resultLocation) in math.h"
	^GEOS call: formatToken with: userDefBlkHan with: userDefFileHan with: floatNum with: resultLocation with: #[37 0 144 1 1 1 3 3 0]!

FloatFormatInit: userDefVMFileHan
	"VMBlockHandle pascal FloatFormatInit(word userDefVMFileHan) in math.goh"
	^GEOS call: userDefVMFileHan with: #[37 0 156 1 1]!

FloatFormatGetFormatParamsWithListEntry: formatInfoStruc
	"word pascal FloatFormatGetFormatParamsWithListEntry(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 157 3 1]!

FloatFormatInitFormatList: formatInfoStruc
	"void pascal FloatFormatInitFormatList(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 158 3 0]!

FloatFormatProcessFormatSelected: formatInfoStruc
	"void pascal FloatFormatProcessFormatSelected(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 159 3 0]!

FloatFormatInvokeUserDefDB: formatInfoStruc
	"void pascal FloatFormatInvokeUserDefDB(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 160 3 0]!

FloatFormatUserDefOK: formatInfoStruc
	"word pascal FloatFormatUserDefOK(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 161 3 1]!

FloatFormatGetFormatTokenWithName: formatInfoStruc
	"word pascal FloatFormatGetFormatTokenWithName(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 162 3 1]!

FloatFormatGetFormatParamsWithToken: formatInfoStruc with: buffer
	"void pascal FloatFormatGetFormatParamsWithToken(FormatInfoStruc *formatInfoStruc, FormatParams *buffer) in math.goh"
	^GEOS call: formatInfoStruc with: buffer with: #[37 0 163 3 3 0]!

FloatFormatDelete: formatInfoStruc
	"FormatIdType pascal FloatFormatDelete(FormatInfoStruc *formatInfoStruc) in math.goh"
	^GEOS call: formatInfoStruc with: #[37 0 164 3 1]!

FloatFormatAddFormat: formatInfoStruc with: formatParams with: formatToken
	"word pascal FloatFormatAddFormat(FormatInfoStruc *formatInfoStruc, FormatParams *formatParams, word formatToken) in math.goh"
	^GEOS call: formatInfoStruc with: formatParams with: formatToken with: #[37 0 166 3 3 1 1]!

!

GenControl subclass: #FloatFormat
	instanceVariableNames: ''
	classVariableNames: ''!

!FloatFormat comment!
Library math, file math.goh! !

!FloatFormat class methodsFor: 'library linkage'!

library
	^37!

entry
	^199!
!

!FloatFormat methodsFor: 'Geos instance variables'!

formatInfoStrucHan
	"@instance word formatInfoStrucHan"
	^self wordAt: 25!

formatInfoStrucHan: value
	"@instance word formatInfoStrucHan"
	^self wordAt: 25 put: value!

!

!FloatFormat methodsFor: 'Geos vardata'!

tempFloatCtrlUserDefineActive
	"@vardata void TEMP_FLOAT_CTRL_USER_DEFINE_ACTIVE"
	^self addVardata: ##tempFloatCtrlUserDefineActive!

!

!FloatFormat methodsFor: 'Geos messages'!

requestMoniker
	"@message void MSG_FC_REQUEST_MONIKER()"
	^self geosMessage: #[108 0 2 0 0]!

optionStyleChange
	"@message void MSG_FORMAT_OPTION_STYLE_CHANGE()"
	^self geosMessage: #[108 1 2 0 0]!

optionBooleanChange
	"@message void MSG_FORMAT_OPTION_BOOLEAN_CHANGE()"
	^self geosMessage: #[108 2 2 0 0]!

selected
	"@message void MSG_FORMAT_SELECTED()"
	^self geosMessage: #[108 3 2 0 0]!

userDefInvoke
	"@message void MSG_FORMAT_USER_DEF_INVOKE()"
	^self geosMessage: #[108 4 2 0 0]!

updateUserDefSamples
	"@message void MSG_FORMAT_UPDATE_USER_DEF_SAMPLES()"
	^self geosMessage: #[108 5 2 0 0]!

userDefOk
	"@message void MSG_FORMAT_USER_DEF_OK()"
	^self geosMessage: #[108 6 2 0 0]!

delete
	"@message void MSG_FORMAT_DELETE()"
	^self geosMessage: #[108 7 2 0 0]!

apply
	"@message void MSG_FORMAT_APPLY()"
	^self geosMessage: #[108 8 2 0 0]!

numDecimals
	"@message void MSG_FORMAT_NUM_DECIMALS()"
	^self geosMessage: #[108 9 2 0 0]!

decimalOffset
	"@message void MSG_FORMAT_DECIMAL_OFFSET()"
	^self geosMessage: #[108 10 2 0 0]!

userDefCancel
	"@message void MSG_FORMAT_USER_DEF_CANCEL()"
	^self geosMessage: #[108 11 2 0 0]!

!

